//
//  IFZoomView.h
//  PDFReader
//
//  Created by Dong Li on 12-5-2.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import <UIKit/UIKit.h>

@class IFZoomView;

@protocol IFZoomViewDelegate <NSObject>
- (void)toggleFullScreen:(IFZoomView *)PDFScrollView;
@end

@interface IFZoomView : UIScrollView <UIScrollViewDelegate> {
    CGPoint _touchBeganPoint;
    BOOL _userInteracting;
    BOOL _touchMoved;
    NSInteger _tapCount;
    NSTimeInterval _beganTimestamp;
    __weak id<IFZoomViewDelegate> _zoomViewDelegate;
}

@property (nonatomic, weak) id<IFZoomViewDelegate> zoomViewDelegate;

- (void)stopDecelerating;

@end
